﻿using Spectral1.DATA_ACCESS;
using Spectral1_VBClassLibrary;
using System;
using static Spectral1.DATA_ACCESS.DA_Spectral;
using static Spectral1_VBClassLibrary.DataSet_Spectral;

namespace Spectral1.BUSINESS_LOGIC
{
    public class c_patch
    {
        #region "================ DECLARATIONS ========================"
        static CodeGen_DS_Spectral _CGS;
        static DA_Spectral _DASP;
        private Int32 _patch_id = 0;

        #endregion

        #region "================ PROPERTIES ========================"
        public Int32 patch_id { get { return _patch_id; } }

        private patchRow r
        {
            get
            {
                return _CGS.Table_patch.GetRow(patch_id);
            }
        }

        public int current_lfo_envelope_config_id
        {
            get { return _CGS.Table_lfo_envelope_config.CurrentRow.lfo_envelope_config_id; }
        }

        public int current_adsr_section_id
        {
            get { return _CGS.Table_adsr_section.CurrentRow.adsr_section_id; }
        }

        public int current_adsr_section_envelope_config_id
        {
            get { return _CGS.Table_adsr_section_envelope_config.CurrentRow.adsr_section_envelope_config_id; }
        }
        public adsr_section_envelope_configRow current_adsr_section_envelope_config_row
        {
            get { return _CGS.Table_adsr_section_envelope_config.GetRow(patch_id, current_adsr_section_id, current_adsr_section_envelope_config_id); }
        }

        public adsr_sectionRow current_adsr_section_row
        {
            get { return _CGS.Table_adsr_section.GetRow(patch_id, current_adsr_section_id); }
        }

        public string patch_guid8
        {
            get
            {
                if (r == null)
                {
                    return "";
                }
                else
                {
                    return r.patch_guid8;
                }
            }
            set
            {
                if (r != null)
                { r.patch_guid8 = value; }
            }
        }

        public string description
        {
            get
            {
                if (r == null)
                {
                    return "";
                }
                else
                {
                    _DASP.data_changed.patch.set_misc(true);
                    return r.patch_name;
                }
            }
            set
            {
                if (r != null)
                { r.patch_name = value; }
            }

        }

        public int waveform_set_id
        {
            get { return r.waveform_set_id; }
            set { 
                r.waveform_set_id = value;
                _DASP.data_changed.patch.set_misc(true);
            }
        }

        public int body_resonance_filter_id
        {
            get { return r.body_resonance_filter_id; }
            set { 
                r.body_resonance_filter_id = value;
                _DASP.data_changed.patch.set_misc(true);
            }
        }

        public int active_layers
        {
            get { return r.active_layers; }
            set { 
                r.active_layers = value;
                _DASP.data_changed.patch.set_misc(true);
            }
        }

        public float degree_of_random_detuning
        {
            get { return r.degree_of_random_detuning; }
            set { 
                r.degree_of_random_detuning = value;
                _DASP.data_changed.patch.set_misc(true);
            }
        }

        public int patch_category_id
        {
            get { return r.patch_category_id; }
            set { 
                r.patch_category_id = value;
                _DASP.data_changed.patch.set_misc(true);
            }
        }

        public int patch_type_id
        {
            get { return r.patch_type_id; }
            set { 
                r.patch_type_id = value;
                _DASP.data_changed.patch.set_misc(true);
            }
        }

        public int sustain_enabled
        {
            get { return r.sustain_enabled; }
            set { 
                r.sustain_enabled = value;
                _DASP.data_changed.patch.set_misc(true);
            }
        }

        public float degree_of_random_phase
        {
            get { return r.degree_of_random_phase; }
            set { 
                r.degree_of_random_phase = value;
                _DASP.data_changed.patch.set_misc(true);
            }
        }

        public float degree_of_regular_detuning
        {
            get { return r.degree_of_regular_detuning; }
            set { 
                r.degree_of_regular_detuning = value;
                _DASP.data_changed.patch.set_misc(true);
            }
        }

        public int detuning_mode_id
        {
            get { return r.detuning_mode_id; }
            set { 
                r.detuning_mode_id = value;
                _DASP.data_changed.patch.set_misc(true);
            }
        }

        public int key_scale_split_note_id
        {
            get { return r.key_scale_split_note_id; }
            set { 
                r.key_scale_split_note_id = value;
                _DASP.data_changed.patch.set_misc(true);
            }
        }

        public float layer0_st_inc_q11_5_detune
        {
            get { return r.layer0_st_inc_q11_5_detune; }
            set { 
                r.layer0_st_inc_q11_5_detune = value;
                _DASP.data_changed.patch.set_misc(true);
            }
        }

        public float layer1_st_inc_q11_5_detune
        {
            get { return r.layer1_st_inc_q11_5_detune; }
            set {
                r.layer1_st_inc_q11_5_detune = value;
                _DASP.data_changed.patch.set_misc(true);
            }
        }

        public float layer2_st_inc_q11_5_detune
        {
            get { return r.layer2_st_inc_q11_5_detune; }
            set { 
                r.layer2_st_inc_q11_5_detune = value;
                _DASP.data_changed.patch.set_misc(true);
            }
        }

        public int portamento_enabled
        {
            get { return r.portamento_enabled; }
            set {
                r.portamento_enabled = value;
                _DASP.data_changed.patch.set_misc(true);
            }
        }

        public int pitch_bend_enabled
        {
            get { return r.pitch_bend_enabled; }
            set { 
                r.pitch_bend_enabled = value;
                _DASP.data_changed.patch.set_misc(true);
            }
        }

        public float portamento_rate
        {
            get { return r.portamento_rate; }
            set {
                r.portamento_rate = value;
                _DASP.data_changed.patch.set_misc(true);
            }
        }

        #endregion

        #region "================ METHODS ========================"
        public c_patch(CodeGen_DS_Spectral CGS, DA_Spectral DASP,Int32 patch_id)
        {
            _CGS = CGS;
            _DASP = DASP;
            _patch_id = patch_id;
        }

        public void ClonePatch(Int32 source_patch_id)
        {
            patchRow prs = _CGS.Table_patch.GetRow(source_patch_id);

            //Patch
            Int32 new_patch_id = _CGS.Table_patch.AddRow2(BL_Spectral.GetNewGuid8(), "COPY_" + prs.patch_name, prs.patch_type_id, prs.patch_category_id, prs.waveform_set_id, prs.body_resonance_filter_id, prs.sustain_enabled, prs.pitch_bend_enabled, prs.portamento_enabled, prs.portamento_rate, prs.degree_of_regular_detuning, prs.degree_of_random_detuning, prs.degree_of_random_phase, prs.active_layers, prs.detuning_mode_id, prs.layer0_st_inc_q11_5_detune, prs.layer1_st_inc_q11_5_detune, prs.layer2_st_inc_q11_5_detune, c4_note_number);
            patchRow new_patch_row = _CGS.Table_patch.GetRow(new_patch_id);
            patchRow cloned_patch_row = _CGS.Table_patch.GetRow(_CGS.Table_patch.CurrentRow.patch_id);

            new_patch_row.active_layers = cloned_patch_row.active_layers;
            new_patch_row.body_resonance_filter_id = cloned_patch_row.body_resonance_filter_id;
            new_patch_row.degree_of_random_detuning = cloned_patch_row.degree_of_random_detuning;
            new_patch_row.degree_of_random_phase = cloned_patch_row.degree_of_random_phase;
            new_patch_row.degree_of_regular_detuning = cloned_patch_row.degree_of_regular_detuning;
            new_patch_row.layer0_st_inc_q11_5_detune = cloned_patch_row.layer0_st_inc_q11_5_detune;
            new_patch_row.layer1_st_inc_q11_5_detune = cloned_patch_row.layer1_st_inc_q11_5_detune;
            new_patch_row.layer2_st_inc_q11_5_detune = cloned_patch_row.layer2_st_inc_q11_5_detune;
            new_patch_row.patch_category_id = cloned_patch_row.patch_category_id;
            new_patch_row.patch_type_id = cloned_patch_row.patch_type_id;
            new_patch_row.pitch_bend_enabled = cloned_patch_row.pitch_bend_enabled;
            new_patch_row.portamento_enabled = cloned_patch_row.portamento_enabled;
            new_patch_row.portamento_rate = cloned_patch_row.portamento_rate;
            new_patch_row.sustain_enabled = cloned_patch_row.sustain_enabled;
            new_patch_row.waveform_set_id = cloned_patch_row.waveform_set_id;
            new_patch_row.key_scale_split_note_id = cloned_patch_row.key_scale_split_note_id;

            //Other patch related tables
            InitialisePatchRelatedTables(new_patch_row.patch_id, cloned_patch_row.patch_id);

            _DASP.data_changed.patch.set_all(true);
        }

        public void InitialisePatchRelatedTables(Int32 new_patch_id, Int32 cloned_patch_id)
        {
            //LFO Envelope config
            for (Int32 i = 0; i < max_lfos; i++)
            {
                _CGS.Table_lfo_envelope_config.DeleteRow(new_patch_id, i); //Ensure any existing row is deleted
                _CGS.Table_lfo_envelope_config.AddRow3(new_patch_id, i, 0, 0, 0, Convert.ToInt32(used_midi_cc.ucc_none), Convert.ToInt32(used_midi_cc.ucc_none));
                if (cloned_patch_id != -1)
                {
                    lfo_envelope_configRow cloned_lfoecr = _CGS.Table_lfo_envelope_config.GetRow(cloned_patch_id, i);
                    lfo_envelope_configRow new_lfoecr = _CGS.Table_lfo_envelope_config.GetRow(new_patch_id, i);
                    new_lfoecr.default_wt_inc_q11_5 = cloned_lfoecr.default_wt_inc_q11_5;
                    new_lfoecr.depth_cc_source = cloned_lfoecr.depth_cc_source;
                    new_lfoecr.enabled = cloned_lfoecr.enabled;
                    new_lfoecr.freq_cc_source = cloned_lfoecr.freq_cc_source;
                    new_lfoecr.lfo_wave_type_id = cloned_lfoecr.lfo_wave_type_id;
                }
            }

            //ADSR section and section envelope config
            for (Int32 a = 0; a < max_adsr_sections; a++)
            {
                Int32 section_end_time_ms = 0;
                switch ((adsr_sections)a)
                {
                    case adsr_sections.adsr_section_attack:
                        section_end_time_ms = 25;
                        break;
                    case adsr_sections.adsr_section_decay:
                        section_end_time_ms = 50;
                        break;
                    case adsr_sections.adsr_section_sustain:
                        section_end_time_ms = 60000;
                        break;
                    case adsr_sections.adsr_section_release:
                        section_end_time_ms = 50;
                        break;
                }

                _CGS.Table_adsr_section.DeleteRow(new_patch_id, a);//Ensure any existing row is deleted
                _CGS.Table_adsr_section.AddRow3(new_patch_id, a, 1, section_end_time_ms, 0, 0, Convert.ToInt32(inharmonic_sample_playback_modes.sample_playback_mode_one_shot), Convert.ToInt32(inharmonic_samples.inharmonic_sample_none));
                if (cloned_patch_id != -1)
                {
                    adsr_sectionRow cloned_adsrsr = _CGS.Table_adsr_section.GetRow(cloned_patch_id, a);
                    adsr_sectionRow new_adsrsr = _CGS.Table_adsr_section.GetRow(new_patch_id, a);
                    new_adsrsr.end_time_ms = cloned_adsrsr.end_time_ms;
                    new_adsrsr.end_time_ms_keyscale_upper = cloned_adsrsr.end_time_ms_keyscale_upper;
                    new_adsrsr.end_time_ms_keyscale_lower = cloned_adsrsr.end_time_ms_keyscale_lower;
                    new_adsrsr.flag_active = cloned_adsrsr.flag_active;
                    new_adsrsr.inharmonic_sample_id = cloned_adsrsr.inharmonic_sample_id;
                    new_adsrsr.inharmonic_sample_playback_mode_id = cloned_adsrsr.inharmonic_sample_playback_mode_id;
                }

                for (Int32 v = 0; v < max_envelopes; v++)
                {
                    _CGS.Table_adsr_section_envelope_config.DeleteRow(new_patch_id, a, v);//Ensure any existing row is deleted
                    _CGS.Table_adsr_section_envelope_config.AddRow3(new_patch_id, a, v, Convert.ToInt32(env_types.env_type_none), 0, 0, 0, 0, 0, 0, 3, 0, 0);
                    if (cloned_patch_id != -1)
                    {
                        adsr_section_envelope_configRow cloned_adsrsecr = _CGS.Table_adsr_section_envelope_config.GetRow(cloned_patch_id, a, v);
                        adsr_section_envelope_configRow new_adsrsecr = _CGS.Table_adsr_section_envelope_config.GetRow(new_patch_id, a, v);
                        new_adsrsecr.depth_env_exp_multiplier = cloned_adsrsecr.depth_env_exp_multiplier;
                        new_adsrsecr.depth_env_exp_multiplier_keyscale_upper = cloned_adsrsecr.depth_env_exp_multiplier_keyscale_upper;
                        new_adsrsecr.depth_env_exp_multiplier_keyscale_lower = cloned_adsrsecr.depth_env_exp_multiplier_keyscale_lower;
                        new_adsrsecr.depth_env_lin_delta = cloned_adsrsecr.depth_env_lin_delta;
                        new_adsrsecr.depth_env_lin_delta_keyscale_upper = cloned_adsrsecr.depth_env_lin_delta_keyscale_upper;
                        new_adsrsecr.depth_env_lin_delta_keyscale_lower = cloned_adsrsecr.depth_env_lin_delta_keyscale_lower;
                        new_adsrsecr.depth_env_target = cloned_adsrsecr.depth_env_target;
                        new_adsrsecr.depth_env_target_keyscale_upper = cloned_adsrsecr.depth_env_target_keyscale_upper;
                        new_adsrsecr.depth_env_target_keyscale_lower = cloned_adsrsecr.depth_env_target_keyscale_lower;
                        new_adsrsecr.depth_env_type_id = cloned_adsrsecr.depth_env_type_id;
                    }
                }
            }

            //Biquad EQ
            for (Int32 b = 0; b < max_biquad_filters; b++)
            {
                _CGS.Table_biquad_eq.DeleteRow(new_patch_id, b);//Ensure any existing row is deleted
                _CGS.Table_biquad_eq.AddRow3(new_patch_id, b, Convert.ToInt32(filter_types.peak), 10000, (float)0, 10);
                _CGS.Table_biquad_eq_calculated.DeleteRow(new_patch_id, b);//Ensure any existing row is deleted
                _CGS.Table_biquad_eq_calculated.AddRow3(new_patch_id, b, (float)2.0811348, (float)-0.003917203, (float)-1.08113086, (float)-0.003917203, (float)3.8361195E-06);
            }

            //envelope control
            for (Int32 e = 0; e < max_envelopes; e++)
            {
                if (cloned_patch_id != -1)
                {
                    _CGS.Table_envelope_control.DeleteRow(new_patch_id, e);//Ensure any existing row is deleted
                    _CGS.Table_envelope_control.AddRow3(new_patch_id, e, _CGS.Table_envelope_control.GetRow(cloned_patch_id, e).depth_initial_level, _CGS.Table_envelope_control.GetRow(cloned_patch_id, e).gain_cc_source);
                }
                else
                {
                    float depth_initial_value = 0;
                    int gain_cc_source;
                    switch ((envelope)e)
                    {
                        case envelope.env_amplitude:
                            depth_initial_value = 0;
                            gain_cc_source = Convert.ToInt32(used_midi_cc.ucc_velocity);
                            break;
                        case envelope.env_noise:
                            depth_initial_value = 0;
                            gain_cc_source = Convert.ToInt32(used_midi_cc.ucc_none);
                            break;
                        case envelope.env_noise_cutoff_level:
                            depth_initial_value = 100;
                            gain_cc_source = Convert.ToInt32(used_midi_cc.ucc_none);
                            break;
                        case envelope.env_pitch:
                            depth_initial_value = 0;
                            gain_cc_source = Convert.ToInt32(used_midi_cc.ucc_none);
                            break;
                        case envelope.env_portamento:
                            depth_initial_value = 0;
                            gain_cc_source = Convert.ToInt32(used_midi_cc.ucc_none);
                            break;
                        case envelope.env_sample:
                            depth_initial_value = 0;
                            gain_cc_source = Convert.ToInt32(used_midi_cc.ucc_velocity);
                            break;
                        case envelope.env_timbre:
                            depth_initial_value = 0;
                            gain_cc_source = Convert.ToInt32(used_midi_cc.ucc_none);
                            break;
                        case envelope.env_timbre_lfo:
                            depth_initial_value = 100;
                            gain_cc_source = Convert.ToInt32(used_midi_cc.ucc_none);
                            break;
                        case envelope.env_tremolo:
                            depth_initial_value = 0;
                            gain_cc_source = Convert.ToInt32(used_midi_cc.ucc_none);
                            break;
                        case envelope.env_vibrato:
                            depth_initial_value = 0;
                            gain_cc_source = Convert.ToInt32(used_midi_cc.ucc_none);
                            break;
                        default:
                            depth_initial_value = 0;
                            gain_cc_source = Convert.ToInt32(used_midi_cc.ucc_none);
                            break;
                    }

                    _CGS.Table_envelope_control.DeleteRow(new_patch_id, e); //Ensure any existing row is deleted
                    _CGS.Table_envelope_control.AddRow3(new_patch_id, e, depth_initial_value, gain_cc_source);
                }
            }
        }

        public lfo_envelope_configRow lfo_envelope_config_row(int patch_id, int lfo_envelope_config_id)
        {
            return _CGS.Table_lfo_envelope_config.GetRow(patch_id, lfo_envelope_config_id);
        }

        public envelope_controlRow envelope_control_row(int patch_id, int envelope_control_id)
        {  
            return _CGS.Table_envelope_control.GetRow(patch_id, envelope_control_id);
        }

        public adsr_sectionRow adsr_section_row(int patch_id, int adsr_section_id)
        {
            return _CGS.Table_adsr_section.GetRow(patch_id, adsr_section_id);
        }

        public adsr_section_envelope_configRow adsr_section_envelope_config_row(int patch_id, int adsr_section_id,int adsr_section_envelope_config_id)
        {
            return _CGS.Table_adsr_section_envelope_config.GetRow(patch_id, adsr_section_id,adsr_section_envelope_config_id);
        }

        #endregion

        #region "=============== METHODS - patch items - as strings  ========="
        public string get_string_patch_active_layers()
        {
            return _CGS.Table_patch.CurrentRow.active_layers.ToString();
        }

        public string get_string_patch_random_detuning()
        {
            return _CGS.Table_patch.CurrentRow.degree_of_random_detuning.ToString();
        }

        public string get_string_patch_regular_detuning()
        {
            return _CGS.Table_patch.CurrentRow.degree_of_regular_detuning.ToString();
        }

        public string get_string_patch_detuning_mode()
        {
            int m =  _CGS.Table_patch.CurrentRow.detuning_mode_id;
            return DA_Spectral.GetDetuningModeFromID((detune_modes)m);
        }

        public string get_string_patch_keyscale_split_note_name()
        {
            int n = _CGS.Table_patch.CurrentRow.key_scale_split_note_id;
            return DA_Spectral.GetMIDINoteNameFromID(n);
        }

        public string get_string_patch_layer0_detune()
        {
            float detune = _CGS.Table_patch.CurrentRow.layer0_st_inc_q11_5_detune;
            return detune.ToString("##0.00");
        }

        public string get_string_patch_layer1_detune()
        {
            float detune = _CGS.Table_patch.CurrentRow.layer1_st_inc_q11_5_detune;
            return detune.ToString("##0.00");
        }

        public string get_string_patch_layer2_detune()
        {
            float detune = _CGS.Table_patch.CurrentRow.layer2_st_inc_q11_5_detune;
            return detune.ToString("##0.00");
        }

        public string get_string_patch_portamento_enabled()
        {
            return (_CGS.Table_patch.CurrentRow.portamento_enabled ==1).ToString();
        }

        public string get_string_patch_portamento_rate()
        {
            return _CGS.Table_patch.CurrentRow.portamento_rate.ToString();
        }


        #endregion

        #region "=============== METHODS - lfo envelope config items - as strings  ========="


        public string get_string_lfo_type(int patch_id,int lfo_envelope_config_id)
        {
            return DA_Spectral.GetLFONameFromID((lfos)lfo_envelope_config_id);
        }

        public string get_string_lfo_enabled(int patch_id, int lfo_envelope_config_id)
        {
            return (_CGS.Table_lfo_envelope_config.GetRow(patch_id, lfo_envelope_config_id).enabled == 1).ToString();
        }
        public string get_string_lfo_frequency(int patch_id, int lfo_envelope_config_id)
        {
             float frequency = _CGS.Table_lfo_envelope_config.GetRow(patch_id, lfo_envelope_config_id).default_wt_inc_q11_5;
            return frequency.ToString("##0.00");
        }

        public string get_string_lfo_depth_cc_source(int patch_id, int lfo_envelope_config_id)
        {
            int cc = _CGS.Table_lfo_envelope_config.GetRow(patch_id, lfo_envelope_config_id).depth_cc_source;
            return DA_Spectral.GetCCNameFromID((used_midi_cc)cc);
        }

        public string get_string_lfo_freq_cc_source(int patch_id, int lfo_envelope_config_id)
        {
            int cc = _CGS.Table_lfo_envelope_config.GetRow(patch_id, lfo_envelope_config_id).freq_cc_source;
            return DA_Spectral.GetCCNameFromID((used_midi_cc)cc);
        }

        public string get_string_lfo_wave_type(int patch_id, int lfo_envelope_config_id)
        {
            int wt = _CGS.Table_lfo_envelope_config.GetRow(patch_id, lfo_envelope_config_id).lfo_wave_type_id;
            return DA_Spectral.GetWaveShapeNameFromID((lfo_wave_types)wt);
        }
        #endregion

        #region "=============== METHODS - envelope control items - as strings  ========="
        public string get_string_envelope_control_gain_cc_source(int patch_id, int envelope_control_id)
        {
            int cc = _CGS.Table_envelope_control.GetRow(patch_id, envelope_control_id).gain_cc_source;
            return DA_Spectral.GetCCNameFromID((used_midi_cc)cc);
        }

        public string get_string_envelope_control_initial_level(int patch_id,int envelope_control_id)
        {
            return _CGS.Table_envelope_control.GetRow(patch_id, envelope_control_id).depth_initial_level.ToString();
        }

        public string get_string_envelope_control_envelope_type(int patch_id, int envelope_control_id)
        {
            int e = _CGS.Table_envelope_control.GetRow(patch_id, envelope_control_id).envelope_control_id;
            return DA_Spectral.GetEnvelopeNameFromID((envelope)e);
        }
        #endregion

        #region "=============== METHODS - adsr section items - as strings  ========="
        public string get_string_adsr_section_name(int patch_id,int adsr_section_id)
        {
            int s = _CGS.Table_adsr_section.GetRow(patch_id,adsr_section_id).adsr_section_id;
            return DA_Spectral.GetSectionNameFromID((adsr_sections)s);
        }

        public string get_string_adsr_section_end_time_ms(int patch_id, int adsr_section_id)
        {
            return  _CGS.Table_adsr_section.GetRow(patch_id, adsr_section_id).end_time_ms.ToString();
        }

        public string get_string_adsr_section_end_KSL(int patch_id, int adsr_section_id)
        {
            return _CGS.Table_adsr_section.GetRow(patch_id, adsr_section_id).end_time_ms_keyscale_lower.ToString();
        }

        public string get_string_adsr_section_end_KSU(int patch_id, int adsr_section_id)
        {
            return _CGS.Table_adsr_section.GetRow(patch_id, adsr_section_id).end_time_ms_keyscale_upper.ToString();
        }

        public string get_string_adsr_section_active(int patch_id, int adsr_section_id)
        {
            return (_CGS.Table_adsr_section.GetRow(patch_id, adsr_section_id).flag_active==1).ToString();
        }

        public string get_string_adsr_section_sample_name(int patch_id, int adsr_section_id)
        {
            int s = _CGS.Table_adsr_section.GetRow(patch_id, adsr_section_id).inharmonic_sample_id;
            return DA_Spectral.GetSampleNameFromID((inharmonic_samples)s);
        }

        public string get_string_adsr_section_sample_mode(int patch_id, int adsr_section_id)
        {
            int s = _CGS.Table_adsr_section.GetRow(patch_id, adsr_section_id).inharmonic_sample_playback_mode_id;
            return DA_Spectral.GetSampleModeFromID((inharmonic_sample_playback_modes)s);
        }
        #endregion

        #region "=============== METHODS - adsr envelope config items - as strings  ========="
        public string get_string_adsr_envelope_config_section_name(int patch_id,int adsr_section_id,int adsr_section_envelope_config_id)
        {
            int s = _CGS.Table_adsr_section_envelope_config.GetRow(patch_id,adsr_section_id,adsr_section_envelope_config_id).adsr_section_id;
            return DA_Spectral.GetSectionNameFromID((adsr_sections)s);
        }

        public string get_string_adsr_envelope_config_envelope_name(int patch_id, int adsr_section_id, int adsr_section_envelope_config_id)
        {
            int e = _CGS.Table_adsr_section_envelope_config.GetRow(patch_id,adsr_section_id,adsr_section_envelope_config_id).adsr_section_envelope_config_id;
            return DA_Spectral.GetEnvelopeNameFromID((envelope)e);
        }

        public string get_string_adsr_envelope_config_exp_mult(int patch_id, int adsr_section_id, int adsr_section_envelope_config_id)
        {
            return _CGS.Table_adsr_section_envelope_config.GetRow(patch_id,adsr_section_id,adsr_section_envelope_config_id).depth_env_exp_multiplier.ToString();
        }

        public string get_string_adsr_envelope_config_exp_mult_KSL(int patch_id, int adsr_section_id, int adsr_section_envelope_config_id)
        {
            return _CGS.Table_adsr_section_envelope_config.GetRow(patch_id,adsr_section_id,adsr_section_envelope_config_id).depth_env_exp_multiplier_keyscale_lower.ToString();
        }

        public string get_string_adsr_envelope_config_exp_mult_KSU(int patch_id, int adsr_section_id, int adsr_section_envelope_config_id)
        {
            return _CGS.Table_adsr_section_envelope_config.GetRow(patch_id,adsr_section_id,adsr_section_envelope_config_id).depth_env_exp_multiplier_keyscale_upper.ToString();
        }

        public string get_string_adsr_envelope_config_linear_delta(int patch_id, int adsr_section_id, int adsr_section_envelope_config_id)
        {
            return _CGS.Table_adsr_section_envelope_config.GetRow(patch_id,adsr_section_id,adsr_section_envelope_config_id).depth_env_lin_delta.ToString();
        }

        public string get_string_adsr_envelope_config_linear_delta_KSL(int patch_id, int adsr_section_id, int adsr_section_envelope_config_id)
        {
            return _CGS.Table_adsr_section_envelope_config.GetRow(patch_id,adsr_section_id,adsr_section_envelope_config_id).depth_env_lin_delta_keyscale_lower.ToString();
        }

        public string get_string_adsr_envelope_config_linear_delta_KSU(int patch_id, int adsr_section_id, int adsr_section_envelope_config_id)
        {
            return _CGS.Table_adsr_section_envelope_config.GetRow(patch_id,adsr_section_id,adsr_section_envelope_config_id).depth_env_lin_delta_keyscale_upper.ToString();
        }

        public string get_string_adsr_envelope_config_target(int patch_id, int adsr_section_id, int adsr_section_envelope_config_id)
        {
            float target = _CGS.Table_adsr_section_envelope_config.GetRow(patch_id,adsr_section_id,adsr_section_envelope_config_id).depth_env_target;
            return target.ToString("###0.00");
        }

        public string get_string_adsr_envelope_config_target_KSL(int patch_id, int adsr_section_id, int adsr_section_envelope_config_id)
        {
            return _CGS.Table_adsr_section_envelope_config.GetRow(patch_id,adsr_section_id,adsr_section_envelope_config_id).depth_env_target_keyscale_lower.ToString();
        }

        public string get_string_adsr_envelope_config_target_KSU(int patch_id, int adsr_section_id, int adsr_section_envelope_config_id)
        {
            return _CGS.Table_adsr_section_envelope_config.GetRow(patch_id,adsr_section_id,adsr_section_envelope_config_id).depth_env_target_keyscale_upper.ToString();
        }

        public string get_string_adsr_envelope_config_envelope_type(int patch_id, int adsr_section_id, int adsr_section_envelope_config_id)
        {
            int t =  _CGS.Table_adsr_section_envelope_config.GetRow(patch_id,adsr_section_id,adsr_section_envelope_config_id).depth_env_type_id;
            return DA_Spectral.GetEnvelopeTypeFromID((env_types)t);
        }

        #endregion

    }
}
